<#ibiztemplate>
TARGET=PSAPPVIEWMSG
</#ibiztemplate>
import ViewMessageService from '../view-message-service';
/**
 * ${item.getName()}视图消息服务对象基类
 *
 * @export
 * @class ${item.getCodeName()}MessageServiceBase
 */
export default class ${srfclassname('${item.getCodeName()}')}MessageServiceBase extends ViewMessageService {

<#-- 动态模式为实体数据集合start -->
<#if item.getDynamicMode() == 1>
    /**
     * 支持缓存
     *
     * @type {boolean}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public isEnableCache:boolean = ${item.isEnableCache()?c};

    /**
     * 缓存范围
     *
     * @type {string}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public cacheScope:string = "${item.getCacheScope()}";

    /**
     * 缓存超时
     *
     * @type {number}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public cacheTimeout:number = ${item.getCacheTimeout()?c};

    /**
     * 过期时间
     *
     * @type any
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public static expirationTime:any;

    /**
     * 获取过期时间
     *
     * @type any
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public getExpirationTime(){
        return ${srfclassname('${item.getCodeName()}')}MessageServiceBase.expirationTime;
    }

    /**
     * 设置过期时间
     *
     * @type any
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public setExpirationTime(value:any){
        ${srfclassname('${item.getCodeName()}')}MessageServiceBase.expirationTime = value; 
    }

    /**
     * 应用实体对象名
     *
     * @type {string}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */  
    public appDataEntityName:string = "<#if item.getPSAppDataEntity()??>${item.getPSAppDataEntity().getCodeName()}</#if>";

    /**
     * 实体数据集合接口名
     *
     * @type {string}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */  
    public appDataSetName:string = "<#if item.getPSAppDEDataSet()??>${item.getPSAppDEDataSet().getCodeName()}</#if>";
</#if>
<#-- 动态模式为实体数据集合end -->

    /**
     * Creates an instance of  ${srfclassname('${item.getCodeName()}')}MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public initBasicParam(){
        this.id = "${item.getId()}";
        this.name = "${item.getName()}";
        this.codename = "<#if item.getCodeName()??>${item.getCodeName()}</#if>";
        this.title = "<#if item.getTitle()??>${item.getTitle()}</#if>";
        this.content = "<#if item.getTitle()??>${item.getTitle()}</#if>";
        this.closeMode = "";
        this.position = "<#if item.getPosition() !="">${item.getPosition()}<#else>TOP</#if>";
        this.type = "<#if item.getMessageType() !="">${item.getMessageType()}<#else>INFO</#if>";
        this.isEnableRemove = ${item.isEnableRemove()?c};
        this.order = 1;
        this.dynamicMode = "<#if item.getDynamicMode() == 0>STATIC<#else>DYNAMIC</#if>";
    }

<#-- 动态模式为实体数据集合start -->
<#if item.getDynamicMode() == 1>
    /**
     * 获取远程数据
     *
     * @param {*} context
     * @param {*} data
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public getItems(context: any={}, data: any={}, isloading?: boolean): Promise<any> {
        return new Promise((resolve, reject) => {
            this.entityService.getService(this.appDataEntityName.toLowerCase()).then((service:any) =>{
                if(service[this.appDataSetName] && service[this.appDataSetName] instanceof Function){
                    const promise: Promise<any> = service[this.appDataSetName](context, data, isloading);
                    promise.then((response: any) => {
                        if (response && response.status === 200) {
                            const data =  response.data;
                            resolve(this.doItems(data));
                        } else {
                            resolve([]);
                        }
                    }).catch((response: any) => {
                        console.error(response);
                        reject(response);
                    });
                }
            })
        });
    }

    /**
     * 处理数据
     *
     * @public
     * @param {any[]} items
     * @returns {any[]}
     * @memberof ${srfclassname('${item.getCodeName()}')}MessageServiceBase
     */
    public doItems(items: any[]): any[] {
        let _items: any[] = [];
        items.forEach((item: any) => {
            let itemdata:any = {
                id:"${item.getId()}",
                name:"${item.getName()}",
                codename:"<#if item.getCodeName()??>${item.getCodeName()}</#if>",
                title:"<#if item.getTitle()??>${item.getTitle()}</#if>",
                content:"<#if item.getTitle()??>${item.getTitle()}</#if>",
                closeMode:"",
                position:"<#if item.getPosition() !="">${item.getPosition()}<#else>TOP</#if>",
                type:"<#if item.getMessageType() !="">${item.getMessageType()}<#else>INFO</#if>",
                isEnableRemove:${item.isEnableRemove()?c},
                order:1,
                dynamicMode:"DYNAMIC"
            };
            <#if item.getTitlePSDEField()??>Object.assign(itemdata,{title:item['${item.getTitlePSDEField().getCodeName()?lower_case}']});</#if>
            <#if item.getContentPSDEField()??>Object.assign(itemdata,{content:item['${item.getContentPSDEField().getCodeName()?lower_case}']});</#if>
            <#if item.getMsgPosPSDEField()??>Object.assign(itemdata,{position:item['${item.getMsgPosPSDEField().getCodeName()?lower_case}']});</#if>
            <#if item.getMsgTypePSDEField()??>Object.assign(itemdata,{type:item['${item.getMsgTypePSDEField().getCodeName()?lower_case}']});</#if>
            <#if item.getOrderValuePSDEField()??>Object.assign(itemdata,{order:item['${item.getOrderValuePSDEField().getCodeName()?lower_case}']});</#if>
            <#if item.getRemoveFlagPSDEField()??>Object.assign(itemdata,{isEnableRemove:item['${item.getRemoveFlagPSDEField().getCodeName()?lower_case}']});</#if>
            _items.push(itemdata);
        });
        return _items;
    }
</#if>
<#-- 动态模式为实体数据集合end -->
}